<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ad;
use Illuminate\Http\Request;

class AdController extends Controller
{
    public function index()
    {
        $ads = Ad::all();
        return view('admin.ads.index', compact('ads'));
    }

    public function create()
    {
        return view('admin.ads.create');
    }

    public function store(Request $request)
    {
        $request->validate(['position' => 'required', 'type' => 'required']);
        
        $imagePath = null;
        if ($request->hasFile('ad_image')) {
            $imagePath = $request->file('ad_image')->store('ads', 'public');
        }

        Ad::create([
            'position' => $request->position,
            'type' => $request->type,
            'ad_code' => $request->ad_code,
            'ad_image' => $imagePath,
            'ad_url' => $request->ad_url,
            'expiry_date' => $request->expiry_date,
        ]);

        return redirect()->route('admin.ads.index')->with('success', 'Ad created successfully');
    }
}
