<?php

namespace App\Http\Controllers;

use App\Models\NewsPost;
use App\Models\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CommentController extends Controller
{
    public function store(Request $request, NewsPost $post)
    {
        $request->validate(['comment' => 'required']);
        
        Comment::create([
            'news_post_id' => $post->id,
            'user_id' => Auth::id(),
            'comment' => $request->comment,
        ]);

        return back()->with('success', 'Comment posted');
    }
}
