<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class ReporterMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();
            if ($user->hasRole('admin')) {
                return $next($request);
            }
            if ($user->hasRole('reporter') && $user->status === 'active') {
                return $next($request);
            }
        }

        abort(403, 'Unauthorized access or your reporter account is pending activation.');
    }
}
