<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(125);
        \Illuminate\Pagination\Paginator::useBootstrapFive();

        // Welcome Email Listener
        \Illuminate\Support\Facades\Event::listen(
            \Illuminate\Auth\Events\Registered::class,
            function (\Illuminate\Auth\Events\Registered $event) {
                \Illuminate\Support\Facades\Mail::to($event->user->email)->send(new \App\Mail\WelcomeMail($event->user));
            }
        );
    }
}
