@extends('layouts.admin')

@section('page_title', 'Analytics Dashboard')

@section('content')
<!-- Stats Cards -->
<div class="row">
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-primary">
            <div class="inner">
                <h3>{{ number_format($totalViews) }}</h3>
                <p>Total Page Views</p>
            </div>
            <div class="icon"><i class="fa-solid fa-eye"></i></div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-success">
            <div class="inner">
                <h3>{{ number_format($todayViews) }}</h3>
                <p>Today's Views</p>
            </div>
            <div class="icon"><i class="fa-solid fa-calendar-day"></i></div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-warning">
            <div class="inner">
                <h3>{{ number_format($uniqueVisitors) }}</h3>
                <p>Unique Visitors</p>
            </div>
            <div class="icon"><i class="fa-solid fa-users"></i></div>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-info">
            <div class="inner">
                <h3>{{ number_format($todayUnique) }}</h3>
                <p>Today's Unique Visitors</p>
            </div>
            <div class="icon"><i class="fa-solid fa-user-check"></i></div>
        </div>
    </div>
</div>

<!-- Chart -->
<div class="card mb-4">
    <div class="card-header">
        <h3 class="card-title"><i class="fa fa-chart-line me-2"></i>Page Views – Last 30 Days</h3>
    </div>
    <div class="card-body">
        <canvas id="viewsChart" height="80"></canvas>
    </div>
</div>

<div class="row">
    <!-- Top News -->
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h3 class="card-title"><i class="fa fa-trophy me-2 text-warning"></i>Top 10 Most Viewed News</h3>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Views</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($topNews as $i => $item)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td>
                                @if($item->newsPost)
                                <a href="{{ route('news.show', $item->newsPost->slug) }}" target="_blank">{{ Str::limit($item->newsPost->title, 40) }}</a>
                                @else
                                <span class="text-muted">Deleted</span>
                                @endif
                            </td>
                            <td><span class="badge bg-primary">{{ number_format($item->view_count) }}</span></td>
                        </tr>
                        @empty
                        <tr><td colspan="3" class="text-center text-muted py-3">No data yet</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Top Pages -->
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h3 class="card-title"><i class="fa fa-file me-2 text-info"></i>Top 10 Pages</h3>
            </div>
            <div class="card-body p-0">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Page URL</th>
                            <th>Views</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($topPages as $i => $page)
                        <tr>
                            <td>{{ $i + 1 }}</td>
                            <td><code>/{{ $page->url }}</code></td>
                            <td><span class="badge bg-info">{{ number_format($page->count) }}</span></td>
                        </tr>
                        @empty
                        <tr><td colspan="3" class="text-center text-muted py-3">No data yet</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Top Referrers -->
<div class="card mb-4">
    <div class="card-header">
        <h3 class="card-title"><i class="fa fa-link me-2 text-success"></i>Top 10 Referrers</h3>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Referrer URL</th>
                    <th>Visits</th>
                </tr>
            </thead>
            <tbody>
                @forelse($topReferrers as $i => $ref)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td><a href="{{ $ref->referer }}" target="_blank" rel="noopener">{{ Str::limit($ref->referer, 80) }}</a></td>
                    <td><span class="badge bg-success">{{ number_format($ref->count) }}</span></td>
                </tr>
                @empty
                <tr><td colspan="3" class="text-center text-muted py-3">No referrer data yet</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
const ctx = document.getElementById('viewsChart').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: @json($dates),
        datasets: [
            {
                label: 'Page Views',
                data: @json($views),
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13,110,253,0.1)',
                fill: true,
                tension: 0.4,
                pointRadius: 3
            },
            {
                label: 'Unique Visitors',
                data: @json($uniques),
                borderColor: '#198754',
                backgroundColor: 'rgba(25,135,84,0.1)',
                fill: true,
                tension: 0.4,
                pointRadius: 3
            }
        ]
    },
    options: {
        responsive: true,
        interaction: { intersect: false, mode: 'index' },
        scales: {
            y: { beginAtZero: true, ticks: { precision: 0 } }
        },
        plugins: {
            legend: { position: 'top' }
        }
    }
});
</script>
@endpush
