@extends('layouts.admin')

@section('page_title', 'Dashboard Overview')

@section('content')
<div class="row">
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-primary">
            <div class="inner">
                <h3>{{ $stats['news_count'] }}</h3>
                <p>Total News</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-newspaper"></i> </div>
            <a href="{{ route('admin.news.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-success">
            <div class="inner">
                <h3>{{ $stats['category_count'] }}</h3>
                <p>Categories</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-list"></i> </div>
            <a href="{{ route('admin.categories.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-warning">
            <div class="inner">
                <h3>{{ $stats['reporter_count'] }}</h3>
                <p>Reporters</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-users"></i> </div>
            <a href="{{ route('admin.reporters.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-danger">
            <div class="inner">
                <h3>{{ $stats['ad_count'] }}</h3>
                <p>Active Ads</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-rectangle-ad"></i> </div>
            <a href="{{ route('admin.ads.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
</div>

<!-- New Stats Row -->
<div class="row">
    <div class="col-lg-4 col-6">
        <div class="small-box text-bg-info">
            <div class="inner">
                <h3>{{ number_format($stats['total_views'] ?? 0) }}</h3>
                <p>Total Page Views</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-eye"></i> </div>
            <a href="{{ route('admin.analytics') }}" class="small-box-footer link-light"> View Analytics <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-4 col-6">
        <div class="small-box text-bg-secondary">
            <div class="inner">
                <h3>{{ number_format($stats['today_views'] ?? 0) }}</h3>
                <p>Today's Views</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-calendar-day"></i> </div>
            <a href="{{ route('admin.analytics') }}" class="small-box-footer link-light"> View Analytics <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-4 col-6">
        <div class="small-box text-bg-dark">
            <div class="inner">
                <h3>{{ number_format($stats['subscriber_count'] ?? 0) }}</h3>
                <p>Newsletter Subscribers</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-envelope"></i> </div>
            <span class="small-box-footer">&nbsp;</span>
        </div>
    </div>
</div>
@endsection
