@extends('layouts.admin')

@section('page_title', 'Gallery Management')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Gallery Items</h3>
        <div class="card-tools">
            <div class="btn-group btn-group-sm me-2">
                <a href="{{ route('admin.gallery.index') }}" class="btn {{ $type === 'all' ? 'btn-primary' : 'btn-outline-primary' }}">All</a>
                <a href="{{ route('admin.gallery.index', ['type' => 'photo']) }}" class="btn {{ $type === 'photo' ? 'btn-primary' : 'btn-outline-primary' }}">Photos</a>
                <a href="{{ route('admin.gallery.index', ['type' => 'video']) }}" class="btn {{ $type === 'video' ? 'btn-primary' : 'btn-outline-primary' }}">Videos</a>
            </div>
            <a href="{{ route('admin.gallery.create') }}" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Add Item</a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width:80px">Preview</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Date</th>
                    <th style="width:100px">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($galleries as $item)
                <tr>
                    <td>
                        @if($item->type == 'photo')
                        <img src="{{ asset('storage/'.$item->media) }}" width="80" height="60" style="object-fit:cover; border-radius:4px;" alt="{{ $item->title }}">
                        @else
                        @php
                            $vid = $item->media;
                            if (str_contains($vid, 'youtube.com') || str_contains($vid, 'youtu.be')) {
                                preg_match('/(?:v=|youtu\.be\/)([a-zA-Z0-9_-]{11})/', $vid, $m);
                                $vid = $m[1] ?? $vid;
                            }
                        @endphp
                        <img src="https://img.youtube.com/vi/{{ $vid }}/default.jpg" width="80" height="60" style="object-fit:cover; border-radius:4px;" alt="{{ $item->title }}">
                        @endif
                    </td>
                    <td>{{ $item->title }}</td>
                    <td><span class="badge {{ $item->type === 'photo' ? 'bg-primary' : 'bg-danger' }}">{{ ucfirst($item->type) }}</span></td>
                    <td>{{ Str::limit($item->description, 50) }}</td>
                    <td>{{ $item->created_at->format('d M Y') }}</td>
                    <td>
                        <form action="{{ route('admin.gallery.destroy', $item->id) }}" method="POST" onsubmit="return confirm('Delete this item?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr><td colspan="6" class="text-center text-muted py-4">No gallery items found.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($galleries->hasPages())
    <div class="card-footer">{{ $galleries->appends(['type' => $type])->links() }}</div>
    @endif
</div>
@endsection
