@extends('layouts.admin')

@section('page_title', 'Manage Reporters')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Reporters</h3>
                <div class="card-tools">
                    <a href="{{ route('admin.reporters.create') }}" class="btn btn-primary btn-sm">Add New Reporter</a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Date Joined</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($reporters as $reporter)
                        <tr>
                            <td>{{ $reporter->id }}</td>
                            <td>{{ $reporter->name }}</td>
                            <td>{{ $reporter->email }}</td>
                            <td>
                                @if($reporter->status == 'active')
                                    <span class="badge bg-success">Active</span>
                                @elseif($reporter->status == 'pending')
                                    <span class="badge bg-warning">Pending</span>
                                @else
                                    <span class="badge bg-danger">Suspended</span>
                                @endif
                            </td>
                            <td>{{ $reporter->created_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('admin.reporters.edit', $reporter->id) }}" class="btn btn-sm btn-info">Edit Status</a>
                                <form action="{{ route('admin.reporters.destroy', $reporter->id) }}" method="POST" style="display:inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this reporter?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
</div>
@endsection
