@extends('layouts.app')

@section('title', 'Video Gallery')
@section('meta_description', 'Watch the latest news videos and reports from our video gallery.')

@section('content')
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h2 fw-bold"><i class="fas fa-video text-danger me-2"></i>Video Gallery</h1>
        <a href="{{ route('gallery.photos') }}" class="btn btn-outline-primary">
            <i class="fas fa-images me-1"></i> Photo Gallery
        </a>
    </div>

    @if($videos->count())
    <div class="row g-4">
        @foreach($videos as $video)
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="ratio ratio-16x9">
                    @php
                        $videoId = $video->media;
                        // Support full YouTube URLs
                        if (str_contains($videoId, 'youtube.com') || str_contains($videoId, 'youtu.be')) {
                            preg_match('/(?:v=|youtu\.be\/)([a-zA-Z0-9_-]{11})/', $videoId, $matches);
                            $videoId = $matches[1] ?? $videoId;
                        }
                    @endphp
                    <iframe 
                        src="https://www.youtube.com/embed/{{ $videoId }}" 
                        title="{{ $video->title }}"
                        allowfullscreen
                        class="rounded-top"
                        loading="lazy">
                    </iframe>
                </div>
                <div class="card-body">
                    <h6 class="card-title fw-semibold">{{ $video->title }}</h6>
                    <p class="text-muted small mb-0">
                        <i class="fas fa-clock me-1"></i>{{ $video->created_at->diffForHumans() }}
                    </p>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <div class="mt-4">{{ $videos->links() }}</div>
    @else
    <div class="text-center py-5">
        <i class="fas fa-video fa-4x text-muted mb-3"></i>
        <p class="text-muted">No videos available yet.</p>
    </div>
    @endif
</div>
@endsection
