@extends('layouts.admin')

@section('page_title', 'Reporter Dashboard')

@section('content')
<div class="row">
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-primary">
            <div class="inner">
                <h3>{{ $stats['news_count'] }}</h3>
                <p>My Total News</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-newspaper"></i> </div>
            <a href="{{ route('reporter.news.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-success">
            <div class="inner">
                <h3>{{ $stats['approved_count'] }}</h3>
                <p>Approved News</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-check-circle"></i> </div>
            <a href="{{ route('reporter.news.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-warning">
            <div class="inner">
                <h3>{{ $stats['pending_count'] }}</h3>
                <p>Pending Approval</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-clock"></i> </div>
            <a href="{{ route('reporter.news.index') }}" class="small-box-footer link-light"> More info <i class="fa-solid fa-arrow-circle-right"></i> </a>
        </div>
    </div>
    <div class="col-lg-3 col-6">
        <div class="small-box text-bg-info">
            <div class="inner">
                <h3>{{ $stats['view_count'] }}</h3>
                <p>Total Views</p>
            </div>
            <div class="icon"> <i class="fa-solid fa-eye"></i> </div>
            <div class="small-box-footer"> Views on your news </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h3 class="card-title">Reporter Services</h3>
            </div>
            <div class="card-body">
                <div class="list-group">
                    <a href="{{ route('reporter.idcard') }}" class="list-group-item list-group-item-action">
                        <i class="fa-solid fa-id-card me-2 text-primary"></i> Download My ID Card
                    </a>
                    <a href="{{ route('reporter.appointment') }}" class="list-group-item list-group-item-action">
                        <i class="fa-solid fa-file-pdf me-2 text-danger"></i> Download Appointment Letter
                    </a>
                    <a href="{{ route('profile.edit') }}" class="list-group-item list-group-item-action">
                        <i class="fa-solid fa-user-gear me-2 text-success"></i> Update Profile (Required for ID Card)
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card card-outline card-success">
            <div class="card-header">
                <h3 class="card-title">Quick Actions</h3>
            </div>
            <div class="card-body">
                <a href="{{ route('reporter.news.create') }}" class="btn btn-success btn-lg btn-block mb-3">
                    <i class="fa-solid fa-plus me-2"></i> Submit New News Post
                </a>
                <a href="{{ route('home') }}" target="_blank" class="btn btn-outline-primary btn-block">
                    <i class="fa-solid fa-globe me-2"></i> Visit Live Site
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
