@extends('layouts.admin')

@section('page_title', 'Edit News Post')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="card card-primary">
            <form action="{{ route('reporter.news.update', $news->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="title" class="form-control" value="{{ $news->title }}" required>
                    </div>
                    <div class="form-group">
                        <label>Category</label>
                        <select name="category_id" id="category_id" class="form-control" required>
                            @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ $news->category_id == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Subcategory</label>
                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                            <option value="">Select Subcategory</option>
                            @if($news->category && $news->category->subcategories)
                                @foreach($news->category->subcategories as $sub)
                                <option value="{{ $sub->id }}" {{ $news->subcategory_id == $sub->id ? 'selected' : '' }}>{{ $sub->name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Content</label>
                        <textarea name="content" class="form-control" rows="10" required>{{ $news->content }}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Current Image</label><br>
                        @if($news->image)
                        <img src="{{ asset('storage/'.$news->image) }}" width="150" class="mb-2">
                        @endif
                        <input type="file" name="image" class="form-control">
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update and Submit</button>
                    <a href="{{ route('reporter.news.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

@push('js')
<script>
    const categories = @json($categories);
    document.getElementById('category_id').addEventListener('change', function() {
        const catId = this.value;
        const subSelect = document.getElementById('subcategory_id');
        subSelect.innerHTML = '<option value="">Select Subcategory</option>';
        
        const category = categories.find(c => c.id == catId);
        if (category && category.subcategories) {
            category.subcategories.forEach(sub => {
                const opt = document.createElement('option');
                opt.value = sub.id;
                opt.text = sub.name;
                subSelect.add(opt);
            });
        }
    });
</script>
@endpush
@endsection
