<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Admin\DashboardController;
use Illuminate\Support\Facades\Route;

Route::get('/', [\App\Http\Controllers\NewsController::class, 'index'])->name('home');
Route::get('/news/{slug}', [\App\Http\Controllers\NewsController::class, 'show'])->name('news.show');
Route::get('/category/{slug}', [\App\Http\Controllers\NewsController::class, 'category'])->name('news.category');
Route::get('/search', [\App\Http\Controllers\SearchController::class, 'search'])->name('news.search');
Route::post('/comments/{post}', [\App\Http\Controllers\CommentController::class, 'store'])->middleware('auth')->name('comments.store');
Route::post('/like/{post}', [\App\Http\Controllers\LikeController::class, 'toggle'])->middleware('auth')->name('news.like');
Route::post('/bookmark/{post}', [\App\Http\Controllers\BookmarkController::class, 'toggle'])->middleware('auth')->name('news.bookmark');
Route::get('/bookmarks', [\App\Http\Controllers\BookmarkController::class, 'index'])->middleware('auth')->name('user.bookmarks');
Route::post('/subscribe', [\App\Http\Controllers\SubscriptionController::class, 'store'])->name('subscribe');

// Public Gallery Routes
Route::get('/photo-gallery', [\App\Http\Controllers\GalleryController::class, 'photos'])->name('gallery.photos');
Route::get('/video-gallery', [\App\Http\Controllers\GalleryController::class, 'videos'])->name('gallery.videos');

// Public E-Paper Route
Route::get('/e-paper', [\App\Http\Controllers\EPaperController::class, 'index'])->name('epaper.index');

// SEO Routes
Route::get('/sitemap.xml', [\App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap');
Route::get('/google-news-sitemap.xml', [\App\Http\Controllers\SitemapController::class, 'googleNews'])->name('sitemap.google-news');
Route::get('/robots.txt', [\App\Http\Controllers\SitemapController::class, 'robots'])->name('robots');

// Admin & Reporter Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::middleware(['admin'])->prefix('admin')->name('admin.')->group(function () {
        Route::resource('categories', \App\Http\Controllers\Admin\CategoryController::class);
        Route::resource('subcategories', \App\Http\Controllers\Admin\SubcategoryController::class);
        Route::resource('news', \App\Http\Controllers\Admin\NewsPostController::class);
        Route::patch('news/{news}/approve', [\App\Http\Controllers\Admin\NewsPostController::class, 'approve'])->name('news.approve');
        Route::resource('ads', \App\Http\Controllers\Admin\AdController::class);
        Route::resource('gallery', \App\Http\Controllers\Admin\GalleryController::class);
        Route::resource('e-papers', \App\Http\Controllers\Admin\EPaperController::class);
        Route::resource('reporters', \App\Http\Controllers\Admin\ReporterController::class);
        
        // Analytics
        Route::get('analytics', [\App\Http\Controllers\Admin\AnalyticsController::class, 'index'])->name('analytics');
        
        // Role & Permission Management
        Route::get('roles', [\App\Http\Controllers\Admin\RolePermissionController::class, 'index'])->name('roles.index');
        Route::get('roles/{role}/edit', [\App\Http\Controllers\Admin\RolePermissionController::class, 'edit'])->name('roles.edit');
        Route::put('roles/{role}', [\App\Http\Controllers\Admin\RolePermissionController::class, 'update'])->name('roles.update');
    });

    Route::middleware(['reporter'])->prefix('reporter')->name('reporter.')->group(function () {
        Route::resource('news', \App\Http\Controllers\Reporter\NewsController::class);
        Route::get('id-card', [\App\Http\Controllers\Reporter\NewsController::class, 'idCard'])->name('idcard');
        Route::get('appointment-letter', [\App\Http\Controllers\Reporter\NewsController::class, 'appointmentLetter'])->name('appointment');
    });
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
