

<?php $__env->startSection('title', 'Photo Gallery'); ?>
<?php $__env->startSection('meta_description', 'Browse our photo gallery with latest news images and events.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h2 fw-bold"><i class="fas fa-images text-primary me-2"></i>Photo Gallery</h1>
        <a href="<?php echo e(route('gallery.videos')); ?>" class="btn btn-outline-danger">
            <i class="fas fa-video me-1"></i> Video Gallery
        </a>
    </div>

    <?php if($photos->count()): ?>
    <div class="row g-3">
        <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-6 col-md-4 col-lg-3">
            <div class="card h-100 shadow-sm border-0 gallery-card" 
                 data-bs-toggle="modal" data-bs-target="#photoModal"
                 data-src="<?php echo e(asset('storage/' . $photo->media)); ?>"
                 data-title="<?php echo e($photo->title); ?>"
                 style="cursor:pointer;">
                <div class="gallery-thumb" style="height:180px; overflow:hidden;">
                    <img src="<?php echo e(asset('storage/' . $photo->media)); ?>" 
                         class="card-img-top w-100 h-100" 
                         style="object-fit:cover; transition:transform .3s;"
                         alt="<?php echo e($photo->title); ?>">
                </div>
                <div class="card-body p-2">
                    <p class="card-text small text-muted mb-0 text-truncate"><?php echo e($photo->title); ?></p>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-4"><?php echo e($photos->links()); ?></div>
    <?php else: ?>
    <div class="text-center py-5">
        <i class="fas fa-images fa-4x text-muted mb-3"></i>
        <p class="text-muted">No photos available yet.</p>
    </div>
    <?php endif; ?>
</div>

<!-- Lightbox Modal -->
<div class="modal fade" id="photoModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content bg-dark border-0">
            <div class="modal-header border-0">
                <h5 class="modal-title text-white" id="photoModalTitle"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center p-0">
                <img id="photoModalImg" src="" class="img-fluid" style="max-height:80vh; object-fit:contain;" alt="">
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
document.querySelectorAll('.gallery-card').forEach(card => {
    card.addEventListener('click', function() {
        document.getElementById('photoModalImg').src = this.dataset.src;
        document.getElementById('photoModalTitle').textContent = this.dataset.title;
    });
    card.querySelector('img').addEventListener('mouseover', function() { this.style.transform = 'scale(1.08)'; });
    card.querySelector('img').addEventListener('mouseout', function() { this.style.transform = 'scale(1)'; });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/gallery/photos.blade.php ENDPATH**/ ?>