

<?php $__env->startSection('title', 'Video Gallery'); ?>
<?php $__env->startSection('meta_description', 'Watch the latest news videos and reports from our video gallery.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h2 fw-bold"><i class="fas fa-video text-danger me-2"></i>Video Gallery</h1>
        <a href="<?php echo e(route('gallery.photos')); ?>" class="btn btn-outline-primary">
            <i class="fas fa-images me-1"></i> Photo Gallery
        </a>
    </div>

    <?php if($videos->count()): ?>
    <div class="row g-4">
        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="ratio ratio-16x9">
                    <?php
                        $videoId = $video->media;
                        // Support full YouTube URLs
                        if (str_contains($videoId, 'youtube.com') || str_contains($videoId, 'youtu.be')) {
                            preg_match('/(?:v=|youtu\.be\/)([a-zA-Z0-9_-]{11})/', $videoId, $matches);
                            $videoId = $matches[1] ?? $videoId;
                        }
                    ?>
                    <iframe 
                        src="https://www.youtube.com/embed/<?php echo e($videoId); ?>" 
                        title="<?php echo e($video->title); ?>"
                        allowfullscreen
                        class="rounded-top"
                        loading="lazy">
                    </iframe>
                </div>
                <div class="card-body">
                    <h6 class="card-title fw-semibold"><?php echo e($video->title); ?></h6>
                    <p class="text-muted small mb-0">
                        <i class="fas fa-clock me-1"></i><?php echo e($video->created_at->diffForHumans()); ?>

                    </p>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-4"><?php echo e($videos->links()); ?></div>
    <?php else: ?>
    <div class="text-center py-5">
        <i class="fas fa-video fa-4x text-muted mb-3"></i>
        <p class="text-muted">No videos available yet.</p>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/gallery/videos.blade.php ENDPATH**/ ?>