

<?php $__env->startSection('page_title', 'E-Paper Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Daily Newspaper Uploads</h3>
        <div class="card-tools">
            <a href="<?php echo e(route('admin.e-papers.create')); ?>" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Upload New</a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Date</th>
                    <th>File</th>
                    <th style="width:100px">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $epapers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paper): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($paper->title); ?></td>
                    <td><?php echo e($paper->date ? $paper->date->format('d M Y') : 'N/A'); ?></td>
                    <td><a href="<?php echo e(asset('storage/'.$paper->pdf_path)); ?>" target="_blank" class="btn btn-outline-info btn-sm"><i class="fa fa-file-pdf"></i> View PDF</a></td>
                    <td>
                        <form action="<?php echo e(route('admin.e-papers.destroy', $paper->id)); ?>" method="POST" onsubmit="return confirm('Delete this e-paper?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="4" class="text-center text-muted py-4">No e-papers uploaded yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($epapers->hasPages()): ?>
    <div class="card-footer"><?php echo e($epapers->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/admin/epapers/index.blade.php ENDPATH**/ ?>