

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row">
        <div class="col-md-9">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('news.category', $post->category->slug)); ?>"><?php echo e($post->category->name); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e($post->title); ?></li>
                </ol>
            </nav>
            <h1><?php echo e($post->title); ?></h1>
            <div class="text-muted mb-3">
                By <?php echo e($post->user->name); ?> | <?php echo e($post->created_at->format('M d, Y')); ?> | <i class="fa fa-eye"></i> <?php echo e($post->view_count); ?>

                <?php if(auth()->guard()->check()): ?>
                <div class="mt-2 text-dark">
                    <form action="<?php echo e(route('news.like', $post->id)); ?>" method="POST" style="display:inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-danger btn-sm">
                            <i class="<?php echo e($post->likes->where('user_id', auth()->id())->count() ? 'fa-solid' : 'fa-regular'); ?> fa-heart"></i> Like (<?php echo e($post->likes->count()); ?>)
                        </button>
                    </form>
                    <form action="<?php echo e(route('news.bookmark', $post->id)); ?>" method="POST" style="display:inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-warning btn-sm">
                            <i class="<?php echo e($post->bookmarks->where('user_id', auth()->id())->count() ? 'fa-solid' : 'fa-bookmark'); ?> fa-bookmark"></i> Bookmark
                        </button>
                    </form>
                </div>
                <?php endif; ?>
            </div>
            <?php if($post->image): ?>
            <img src="<?php echo e(asset('storage/'.$post->image)); ?>" class="img-fluid rounded mb-4 w-100">
            <?php endif; ?>
            <div class="content">
                <?php echo $post->content; ?>

            </div>

            <div class="mt-4">
                <h5>Share this news:</h5>
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>" class="btn btn-primary btn-sm" target="_blank"><i class="fab fa-facebook"></i> Facebook</a>
                <a href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(url()->current())); ?>&text=<?php echo e(urlencode($post->title)); ?>" class="btn btn-info btn-sm text-white" target="_blank"><i class="fab fa-twitter"></i> Twitter</a>
                <a href="https://api.whatsapp.com/send?text=<?php echo e(urlencode($post->title.' '.url()->current())); ?>" class="btn btn-success btn-sm" target="_blank"><i class="fab fa-whatsapp"></i> WhatsApp</a>
            </div>

            <hr>
            <h3>Comments</h3>
            <?php if(auth()->guard()->check()): ?>
            <form action="<?php echo e(route('comments.store', $post->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group mb-2">
                    <textarea name="comment" class="form-control" placeholder="Write a comment..." required></textarea>
                </div>
                <button type="submit" class="btn btn-primary btn-sm">Post Comment</button>
            </form>
            <?php else: ?>
            <p>Please <a href="<?php echo e(route('login')); ?>">login</a> to comment.</p>
            <?php endif; ?>

            <div class="mt-4">
                <?php $__currentLoopData = $post->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-2">
                    <div class="card-body py-2">
                        <strong><?php echo e($comment->user->name); ?></strong>
                        <p class="mb-0"><?php echo e($comment->comment); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/news/show.blade.php ENDPATH**/ ?>