

<?php $__env->startSection('title', 'E-Paper – Daily Newspaper'); ?>
<?php $__env->startSection('meta_description', 'Download daily digital newspaper editions in PDF format.'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="text-center mb-5">
        <h1 class="display-5 fw-bold"><i class="fas fa-file-pdf text-danger me-2"></i>E-Paper</h1>
        <p class="text-muted lead">Download our daily newspaper editions as PDF</p>
    </div>

    <?php if($epapers->count()): ?>
    <div class="row g-4">
        <?php $__currentLoopData = $epapers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paper): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-sm-6 col-md-4 col-lg-3">
            <div class="card shadow-sm border-0 text-center h-100">
                <div class="card-body py-4">
                    <div class="mb-3">
                        <i class="fas fa-file-pdf fa-4x text-danger"></i>
                    </div>
                    <h6 class="fw-semibold mb-1"><?php echo e($paper->title); ?></h6>
                    <p class="text-muted small mb-3">
                        <i class="fas fa-calendar-alt me-1"></i>
                        <?php echo e($paper->date ? $paper->date->format('d M Y') : 'N/A'); ?>

                    </p>
                    <a href="<?php echo e(asset('storage/' . $paper->pdf_path)); ?>" 
                       target="_blank"
                       class="btn btn-danger btn-sm w-100"
                       download>
                        <i class="fas fa-download me-1"></i> Download PDF
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-4"><?php echo e($epapers->links()); ?></div>
    <?php else: ?>
    <div class="text-center py-5">
        <i class="fas fa-file-pdf fa-4x text-muted mb-3"></i>
        <p class="text-muted">No e-papers have been uploaded yet. Please check back soon.</p>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/epapers/index.blade.php ENDPATH**/ ?>