

<?php $__env->startSection('page_title', 'Edit News Post'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="card card-primary">
            <form action="<?php echo e(route('reporter.news.update', $news->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card-body">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="title" class="form-control" value="<?php echo e($news->title); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Category</label>
                        <select name="category_id" id="category_id" class="form-control" required>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e($news->category_id == $category->id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Subcategory</label>
                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                            <option value="">Select Subcategory</option>
                            <?php if($news->category && $news->category->subcategories): ?>
                                <?php $__currentLoopData = $news->category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($sub->id); ?>" <?php echo e($news->subcategory_id == $sub->id ? 'selected' : ''); ?>><?php echo e($sub->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Content</label>
                        <textarea name="content" class="form-control" rows="10" required><?php echo e($news->content); ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Current Image</label><br>
                        <?php if($news->image): ?>
                        <img src="<?php echo e(asset('storage/'.$news->image)); ?>" width="150" class="mb-2">
                        <?php endif; ?>
                        <input type="file" name="image" class="form-control">
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update and Submit</button>
                    <a href="<?php echo e(route('reporter.news.index')); ?>" class="btn btn-default">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
    const categories = <?php echo json_encode($categories, 15, 512) ?>;
    document.getElementById('category_id').addEventListener('change', function() {
        const catId = this.value;
        const subSelect = document.getElementById('subcategory_id');
        subSelect.innerHTML = '<option value="">Select Subcategory</option>';
        
        const category = categories.find(c => c.id == catId);
        if (category && category.subcategories) {
            category.subcategories.forEach(sub => {
                const opt = document.createElement('option');
                opt.value = sub.id;
                opt.text = sub.name;
                subSelect.add(opt);
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/reporter/news/edit.blade.php ENDPATH**/ ?>