<?php

namespace App\Http\Controllers;

use App\Models\NewsPost;
use App\Models\PostLike;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LikeController extends Controller
{
    public function toggle(NewsPost $post)
    {
        $like = PostLike::where('news_post_id', $post->id)->where('user_id', Auth::id())->first();
        if ($like) {
            $like->delete();
            return back()->with('success', 'Unliked');
        }
        PostLike::create([
            'news_post_id' => $post->id,
            'user_id' => Auth::id(),
        ]);
        return back()->with('success', 'Liked');
    }
}
