<?php

namespace App\Http\Controllers;

use App\Models\NewsPost;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class SitemapController extends Controller
{
    public function index()
    {
        $posts = NewsPost::where('status', 'approved')
            ->select('slug', 'updated_at', 'created_at')
            ->latest()
            ->get();

        $categories = Category::select('slug', 'updated_at')->get();

        return response()->view('sitemap.index', compact('posts', 'categories'))
            ->header('Content-Type', 'application/xml');
    }

    public function googleNews()
    {
        $posts = NewsPost::where('status', 'approved')
            ->where('created_at', '>=', Carbon::now()->subDays(2))
            ->select('title', 'slug', 'created_at')
            ->latest()
            ->get();

        return response()->view('sitemap.google-news', compact('posts'))
            ->header('Content-Type', 'application/xml');
    }

    public function robots()
    {
        $content = "User-agent: *\nAllow: /\nDisallow: /admin/\nDisallow: /reporter/\nDisallow: /dashboard\nDisallow: /profile\n\nSitemap: " . url('/sitemap.xml') . "\nSitemap: " . url('/google-news-sitemap.xml');

        return response($content, 200)->header('Content-Type', 'text/plain');
    }
}
