<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NewsPost extends Model
{
    protected $fillable = [
        'category_id', 'subcategory_id', 'user_id', 'title', 'slug', 'content', 
        'image', 'video_url', 'status', 'view_count', 'is_breaking', 'is_featured',
        'meta_title', 'meta_description', 'meta_keywords'
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function subcategory()
    {
        return $this->belongsTo(Subcategory::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }

    public function likes()
    {
        return $this->hasMany(PostLike::class, 'news_post_id');
    }

    public function bookmarks()
    {
        return $this->hasMany(Bookmark::class, 'news_post_id');
    }
}
