@extends('layouts.admin')

@section('page_title', 'Add New Ad')

@section('content')
<div class="card card-info">
    <form action="{{ route('admin.ads.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <div class="form-group">
                <label>Position</label>
                <select name="position" class="form-control" required>
                    <option value="header">Header</option>
                    <option value="sidebar">Sidebar</option>
                    <option value="between_news">Between News</option>
                    <option value="footer">Footer</option>
                </select>
            </div>
            <div class="form-group">
                <label>Type</label>
                <select name="type" class="form-control" id="ad_type">
                    <option value="image">Image</option>
                    <option value="code">Code (AdSense)</option>
                </select>
            </div>
            <div class="form-group" id="image_div">
                <label>Ad Image</label>
                <input type="file" name="ad_image" class="form-control">
            </div>
            <div class="form-group" id="code_div" style="display:none">
                <label>Ad Code</label>
                <textarea name="ad_code" class="form-control"></textarea>
            </div>
            <div class="form-group">
                <label>Expiry Date</label>
                <input type="date" name="expiry_date" class="form-control">
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Save Ad</button>
        </div>
    </form>
</div>
@endsection
