@extends('layouts.admin')

@section('page_title', 'Upload E-Paper')

@section('content')
<div class="card card-primary">
    <form action="{{ route('admin.e-papers.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <div class="form-group mb-3">
                <label>Title <span class="text-danger">*</span></label>
                <input type="text" name="title" class="form-control" value="{{ old('title') }}" placeholder="e.g. Daily News - 25 Feb 2026" required>
            </div>
            <div class="form-group mb-3">
                <label>Published Date <span class="text-danger">*</span></label>
                <input type="date" name="date" class="form-control" value="{{ old('date', date('Y-m-d')) }}" required>
            </div>
            <div class="form-group mb-3">
                <label>Select PDF File <span class="text-danger">*</span></label>
                <input type="file" name="pdf_file" class="form-control" accept=".pdf" required>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Upload</button>
            <a href="{{ route('admin.e-papers.index') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
@endsection
