@extends('layouts.admin')

@section('page_title', 'Update Reporter Status')

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">Account Status for {{ $reporter->name }}</h3>
            </div>
            <!-- /.card-header -->
            <!-- form start -->
            <form action="{{ route('admin.reporters.update', $reporter->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="pending" {{ $reporter->status == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="active" {{ $reporter->status == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="suspended" {{ $reporter->status == 'suspended' ? 'selected' : '' }}>Suspended</option>
                        </select>
                    </div>
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update Status</button>
                    <a href="{{ route('admin.reporters.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </form>
        </div>
        <!-- /.card -->
    </div>
</div>
@endsection
