@extends('layouts.admin')

@section('page_title', 'Submit News')

@section('content')
<div class="card card-primary">
    <form action="{{ route('reporter.news.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <div class="form-group">
                <label>Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Category</label>
                <select name="category_id" id="category_id" class="form-control" required>
                    <option value="">Select Category</option>
                    @foreach($categories as $category)
                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>Subcategory</label>
                <select name="subcategory_id" id="subcategory_id" class="form-control">
                    <option value="">Select Subcategory</option>
                </select>
            </div>
@push('js')
<script>
    const categories = @json($categories);
    document.getElementById('category_id').addEventListener('change', function() {
        const catId = this.value;
        const subSelect = document.getElementById('subcategory_id');
        subSelect.innerHTML = '<option value="">Select Subcategory</option>';
        
        const category = categories.find(c => c.id == catId);
        if (category && category.subcategories) {
            category.subcategories.forEach(sub => {
                const opt = document.createElement('option');
                opt.value = sub.id;
                opt.text = sub.name;
                subSelect.add(opt);
            });
        }
    });
</script>
@endpush
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="10" required></textarea>
            </div>
            <div class="form-group">
                <label>Image</label>
                <input type="file" name="image" class="form-control">
            </div>
            <hr>
            <h5>SEO Meta Tags</h5>
            <div class="form-group">
                <label>Meta Title</label>
                <input type="text" name="meta_title" class="form-control">
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Submit News</button>
        </div>
    </form>
</div>
@endsection
