@extends('layouts.admin')

@section('page_title', 'My Submitted News')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Track Approval Status</h3>
                <div class="card-tools">
                    <a href="{{ route('reporter.news.create') }}" class="btn btn-primary btn-sm">Submit New News</a>
                </div>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Views</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($news as $post)
                        <tr>
                            <td>{{ $post->title }}</td>
                            <td>{{ $post->category->name }}</td>
                            <td>
                                @if($post->status == 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @elseif($post->status == 'pending')
                                    <span class="badge bg-warning text-dark">Pending Review</span>
                                @else
                                    <span class="badge bg-danger">Rejected</span>
                                @endif
                            </td>
                            <td>{{ $post->view_count }}</td>
                            <td>{{ $post->created_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('reporter.news.edit', $post->id) }}" class="btn btn-sm btn-info">Edit</a>
                                <form action="{{ route('reporter.news.destroy', $post->id) }}" method="POST" style="display:inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this post?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
