@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3>My Bookmarked News</h3>
    <hr>
    @if($bookmarks->isEmpty())
        <p>You haven't bookmarked any news yet.</p>
    @else
        <div class="row">
            @foreach($bookmarks as $bookmark)
                @if($bookmark->newsPost)
                <div class="col-md-4 mb-3">
                    <div class="card h-100">
                        @if($bookmark->newsPost->image)
                        <img src="{{ asset('storage/'.$bookmark->newsPost->image) }}" class="card-img-top">
                        @endif
                        <div class="card-body">
                            <h5 class="card-title">{{ $bookmark->newsPost->title }}</h5>
                            <a href="{{ route('news.show', $bookmark->newsPost->slug) }}" class="btn btn-primary btn-sm">Read</a>
                            <form action="{{ route('news.bookmark', $bookmark->newsPost->id) }}" method="POST" style="display:inline">
                                @csrf
                                <button type="submit" class="btn btn-danger btn-sm">Remove</button>
                            </form>
                        </div>
                    </div>
                </div>
                @endif
            @endforeach
        </div>
    @endif
</div>
@endsection
